set more off
pause on
graph set window fontface "Times New Roman"
global mainpath "/Users/ekurt/Desktop/MP ASYM/Stata"
set seed 1073741823
cap log close
log using "${mainpath}/Log/DataPrep/2.New variables and trims.log", replace


import excel "${mainpath}/Aggregate Data/Sector level/sectoral depreciation.xlsx", sheet("Sheet1") firstrow clear

tempfile sic
save `sic'

use "${mainpath}/Data/US_fund_merged_basicCleaning_age.dta",clear

* fill in the empty sics

forval k = 1/1 {
by gvkeyn: replace sic_sector = sic_sector[_n+`k'] if sic_sector ==.
by gvkeyn: replace sic_sector = sic_sector[_n-`k'] if sic_sector ==.

}

merge m:m sic_sector using `sic', keep(1 3) nogen

replace delta_y = . if cyear > 1985
replace delta_q = . if cyear > 1985

sort 	gvkeyn qdate
xtset 	gvkeyn qdate

*sample restrictions
drop if (inrange(sic,6000,6799) | inrange(sic,9100,9799) ) 

bysort gvkeyn: gen inv_lom = ppentq - L.ppentq*(1-delta_q) 
bysort cyear: egen avgcapxq = mean(capxq)
bysort cyear: egen avginv_lom = mean(inv_lom)

sort 	gvkeyn qdate

* i. Investment ratio
bysort gvkeyn: gen ppentLag = L.ppentq
bysort gvkeyn: gen logppentLag = log(L.ppentq)
bysort gvkeyn: gen capex_netppe = capxq * 100 / ppentLag
sort cyear

* generating yearly 99,1 percent thresholds
by cyear: egen Threshold99 = pctile(capex_netppe) if capex_netppe ! = ., p(99)
by cyear: egen Threshold1 = pctile(capex_netppe) if capex_netppe ! = ., p(1)

capture drop Trim_InvRatio
gen 	Trim_InvRatio = 0

replace Trim_InvRatio = 1 if capex_netppe > Threshold99 & capex_netppe ! = . 
replace Trim_InvRatio = 1 if capex_netppe < Threshold1 & capex_netppe ! = . 

drop 	Threshold99 Threshold1

gen 		FlagNegCapx = 0
replace 	FlagNegCapx = 1 if capex_netppe < 0 & capex_netppe ! = . 

label variable capex_netppe "Investment Ratio"
ren capex_netppe capex_netppe_cleanedy


gen DebtEquityRatioCEQQ = (dlcq + dlttq)*100 /ceqq       

gen Trim_DebtEquity = 0
sort cyear
by cyear: egen Threshold99 = pctile(DebtEquityRatioCEQQ) if DebtEquityRatioCEQQ ! = ., p(99)
by cyear: egen Threshold1  = pctile(DebtEquityRatioCEQQ) if DebtEquityRatioCEQQ ! = ., p(1)

replace Trim_DebtEquity = 1 if DebtEquityRatioCEQQ > Threshold99 & DebtEquityRatioCEQQ ! = .
replace Trim_DebtEquity = 1 if DebtEquityRatioCEQQ < Threshold1 & DebtEquityRatioCEQQ ! = .
drop 	Threshold99 Threshold1

* Debt to assets 

gen DebtAssetRatio = (dlcq + dlttq)*100 /atq  

gen Trim_DebtAssets_top = 0
gen Trim_DebtAssets_bottom = 0

sort cyear

by cyear: egen Threshold99 = pctile(DebtAssetRatio) if DebtAssetRatio ! = ., p(99)
by cyear: egen Threshold1  = pctile(DebtAssetRatio) if DebtAssetRatio ! = ., p(1)

replace Trim_DebtAssets_top    = 1 if DebtAssetRatio > Threshold99 & DebtAssetRatio ! = .
replace Trim_DebtAssets_bottom = 1 if DebtAssetRatio < Threshold1 & DebtAssetRatio ! = .

drop	Threshold*
 
* Liquidity ratio

gen LiquidityRatio = cheq * 100 / atq   

gen Trim_LiquidityRatio = 0
sum LiquidityRatio, det
replace Trim_LiquidityRatio = 1 if LiquidityRatio > 100 & LiquidityRatio ! = .

* Real Sales and sales growth

sort gvkeyn qdate

by gvkeyn: gen RealSales = saleq/(gva_pindex/100)
by gvkeyn: gen lnRealSales = ln(RealSales)*100

by gvkeyn: gen RealSalesGrowth = (RealSales - L.RealSales)*100 / L.RealSales

gen Trim_SalesGrowth = 0
sort cyear
by cyear: egen Threshold99 = pctile(RealSalesGrowth) if RealSalesGrowth ! = ., p(99)
by cyear: egen Threshold1  = pctile(RealSalesGrowth) if RealSalesGrowth ! = ., p(1)

replace Trim_SalesGrowth = 1 if RealSalesGrowth > Threshold99 & RealSalesGrowth ! = .
replace Trim_SalesGrowth = 1 if RealSalesGrowth < Threshold1 & RealSalesGrowth ! = .

drop 	Threshold*
label var lnRealSales "Log Real Sales"
label var RealSalesGrowth "Real Sales Growth"

* Dividends

gen     DivDummyToday = .
sort 	gvkeyn qdate

replace DivDummyToday = 2 if dvq > 0 & dvq  != .  
replace DivDummyToday = 1 if dvq == 0 & dvq != . 

sort 	gvkeyn qdate 

bysort gvkeyn: gen DivDummy = L.DivDummyToday

label variable DivDummy "Dividends"
label define divlabel 1 "No div." 2 "Paid div."
label values DivDummy divlabel 
sort gvkeyn qdate

* Equity

gen 	Equity = (ceqq/(gva_pindex/100)) - (req/(gva_pindex/100))
gen 	EquityIssuance = Equity - L.Equity
gen 	EquityIssuanceRatio = (ceqq - req - L.ceqq + L.req)*100/L.atq

* Debt Issuance
gen 	TotalDebt = (dlcq/(gva_pindex/100)) + (dlttq/(gva_pindex/100))
gen 	STDebt = (dlcq/(gva_pindex/100))
gen 	LTDebt = (dlttq/(gva_pindex/100))

label var LTDebt "Long term debt"
label var TotalDebt "Total debt"
label var STDebt "Short term debt"

gen     logtotdebt = log(TotalDebt)*100
gen 	DebtIssuance = TotalDebt - L.TotalDebt
gen 	LTDebtIssuanceRatio = (dlttq - L.dlttq)*100 / L.atq
gen 	STDebtIssuanceRatio = (dlcq - L.dlcq)*100 / L.atq
gen 	LTDebtIssuanceNominal = (dlttq - L.dlttq)
gen 	STDebtIssuanceNominal = (dlcq - L.dlcq)
gen 	TotalDebtGrowth = (TotalDebt - L.TotalDebt)*100/L.TotalDebt
gen 	LTDebtGrowth = (LTDebt - L.LTDebt)*100/L.LTDebt
gen 	STDebtGrowth = (STDebt - L.STDebt)*100/L.STDebt


* Debt ratios 

gen STDebtRatio = dlcq*100 / L.atq
label var STDebtRatio "Short term debt ratio"

gen LTDebtRatio = dlttq*100 / L.atq
label var LTDebtRatio "Short term debt ratio"

* Growth
gen 	RealAssetGrowth = ((atq/(gva_pindex/100)) - (L.atq/(L.gva_pindex/100)))/(L.atq/(L.gva_pindex/100))
gen		RealInvGrowth = ((capxq/(gva_pindex/100)) - (L.capxq/(L.gva_pindex/100)))/(L.capxq/(L.gva_pindex/100))

gen Trim_Acquisitions = 0
replace aqcq = 0 if aqcq == .
replace Trim_Acquisitions = 1 if aqcq*100/atq > 5

gen Trim_Baseline = 0

replace Trim_Baseline = max(Trim_InvRatio,Trim_DebtAssets_top,Trim_Acquisitions, Trim_DebtEquity)

replace Trim_Baseline = 1 if f_obssize_t < 20 

gen Trim_Extended = Trim_Baseline
replace Trim_Extended = max(Trim_Baseline,Trim_DebtAssets_bottom, Trim_SalesGrowth)

capture keep sp* emp* l* c* t* G* d_* e* q* g* gs1_d dp* a* R* m* no* o* t* x* i* debt* fa* x* pp* intan prs* s* cap* *4qsum m_ci a* sho* *year gvkey* in* fyrc datadate fyear ppe* Trim* Share* Assets* RealAssetGrowth invt RealInvGrowth TotalDebt* DebtIssuance* Equity* LnInterest RealSales* DebtAsset* LiquidityRatio DivDummy lnRealSales CashFlow* sstk* prstkc* LTDebt* STDebt* xint Pay* dlt* dv cogs sale xsga oibdp oancf rect xint county  state city gva_pindex xrd intan

replace capex_netppe_cleanedy = capex_netppe_cleanedy

save "${mainpath}/Data/CompQuarterlyData.dta", replace

cap log close
